﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace MySilverlightProject2 {
    
    public partial class Page : Canvas {

        // Lista rysunków.
        string[] _images = new string[] {"Autumn Leaves.jpg", "Creek.jpg", 
            "Desert Landscape.jpg", "Dock.jpg", "Forest Flowers.jpg", 
            "Forest.jpg" };
        
        // Określa obecnie wyświetlany rysunek.
        int _selectedIndex = 0;

        public void Page_Loaded(object o, EventArgs e) {

            // Potrzebne do zainicjowania zmiennych.
            InitializeComponent();

            // Określanie obrazu początkowego.
            SetUri();
                        
        }

        void Previous_MouseLeftButtonDown(object sender, MouseEventArgs e) {
            
            // Określanie poprzedniej wartości.
            if (_selectedIndex -1 >= 0) {
                _selectedIndex = _selectedIndex - 1;
            }
            // Przejście do poprzedniego rysunku.
            SetUri();

        }

        void Next_MouseLeftButtonDown(object sender, MouseEventArgs e) {

            // Określanie następnej wartości.
            if (_selectedIndex + 1 < _images.GetLength(0)) {
                _selectedIndex = _selectedIndex + 1;
            }
            // Przejście do następnego rysunku.
            SetUri();

            SetUri();

        }

        private void SetUri() {
            Uri u = new Uri("images/" + _images[_selectedIndex], UriKind.Relative);
            SlideImage.Source = u;        
        }


    }
}
